"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var dgram_1 = require("dgram");
var events = require("events");
var Gateway_1 = require("./Sensors/Gateway");
var THSensor_1 = require("./Sensors/THSensor");
var DoorSensor_1 = require("./Sensors/DoorSensor");
var MotionSensor_1 = require("./Sensors/MotionSensor");
var Plug_1 = require("./Sensors/Plug");
var Button_1 = require("./Sensors/Button");
var Hub = (function (_super) {
    __extends(Hub, _super);
    function Hub() {
        var _this = _super.call(this) || this;
        _this.sensors = {};
        _this.sensorTypes = {
            gateway: 'gateway',
            th: 'sensor_ht',
            button: 'switch',
            plug: 'plug',
            magnet: 'magnet',
            motion: 'motion'
        };
        _this.clickTypes = {
            click: 'click',
            double_click: 'double_click',
            long_click_press: 'long_click_press',
            long_click_release: 'long_click_release',
        };
        return _this;
    }
    Hub.prototype.listen = function () {
        var dgram = require('dgram');
        this.socket = dgram_1.createSocket('udp4');
        var multicastPort = 9898;
        this.socket.on('message', this.onMessage.bind(this));
        this.socket.on('error', this.onError.bind(this));
        this.socket.on('listening', this.onListening.bind(this));
        this.socket.bind(multicastPort);
    };
    Hub.prototype.stop = function (cb) {
        this.socket.close(cb);
    };
    Hub.prototype.onListening = function () {
        this.socket.setBroadcast(true);
        this.socket.setMulticastTTL(128);
        this.socket.addMembership('224.0.0.50');
        var whoIsCommand = '{"cmd": "whois"}';
        this.socket.send(whoIsCommand, 0, whoIsCommand.length, 4321, '224.0.0.50');
    };
    Hub.prototype.onError = function (err) {
        this.emit('error', err);
    };
    Hub.prototype.onMessage = function (msgBuffer) {
        try {
            var msg = JSON.parse(msgBuffer.toString());
        }
        catch (e) {
            return;
        }
        var sensor = this.getSensor(msg.sid);
        if (!sensor) {
            if (!msg.model) {
                return;
            }
            try {
                sensor = this.sensorFactory(msg.sid, msg.model);
            }
            catch (e) {
                this.emit('warning', 'Could not add new sensor: ' + e.message);
            }
        }
        sensor.heartBeat();
        if (msg.data) {
            msg.data = JSON.parse(msg.data);
        }
        if (msg.cmd == 'report' || msg.cmd.indexOf('_ack') != -1) {
            sensor.onMessage(msg);
        }
        this.emit('message', msg);
    };
    Hub.prototype.sendMessage = function (message) {
        var json = JSON.stringify(message);
        this.socket.send(json, 0, json.length, 9898, '224.0.0.50');
    };
    Hub.prototype.sensorFactory = function (sid, model) {
        var sensor = null;
        switch (model) {
            case this.sensorTypes.gateway:
                sensor = new Gateway_1.default(sid, this);
                break;
            case this.sensorTypes.th:
                sensor = new THSensor_1.default(sid, this);
                break;
            case this.sensorTypes.magnet:
                sensor = new DoorSensor_1.default(sid, this);
                break;
            case this.sensorTypes.button:
                sensor = new Button_1.default(sid, this);
                break;
            case this.sensorTypes.plug:
                sensor = new Plug_1.default(sid, this);
                break;
            case this.sensorTypes.motion:
                sensor = new MotionSensor_1.default(sid, this);
                break;
            default:
                throw new Error('Type `' + model + '` is not valid, use one of  Hub::sensorTypes');
        }
        this.registerSensor(sensor);
        return sensor;
    };
    Hub.prototype.getSensor = function (sid) {
        return this.sensors[sid] ? this.sensors[sid] : null;
    };
    Hub.prototype.registerSensor = function (sensor) {
        this.sensors[sensor.sid] = sensor;
    };
    return Hub;
}(events.EventEmitter));
exports.Hub = Hub;
//# sourceMappingURL=Hub.js.map