"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var GenericSensor_1 = require("./GenericSensor");
var Gateway = (function (_super) {
    __extends(Gateway, _super);
    function Gateway(sid, hub) {
        var _this = _super.call(this, sid, hub) || this;
        _this.hub.sendMessage({ cmd: "get_id_list", sid: sid });
        return _this;
    }
    Gateway.prototype.onMessage = function (message) {
        if (message.cmd == 'get_id_list_ack') {
            this.initSensors(message.data);
        }
    };
    Gateway.prototype.initSensors = function (sids) {
        for (var _i = 0, sids_1 = sids; _i < sids_1.length; _i++) {
            var sid = sids_1[_i];
            this.hub.sendMessage({ cmd: "read", sid: sid });
        }
    };
    return Gateway;
}(GenericSensor_1.default));
exports.default = Gateway;
//# sourceMappingURL=Gateway.js.map